-- steps display; per-player
local Player = ...
assert(Player,"StepsDisplay needs Player")

local c

-- todo: coloring, proper handling on no song.
return Def.ActorFrame{
	InitCommand=function(self) c = self:GetChildren() end;
	BeginCommand=cmd(playcommand,"Set");
	SetCommand=function(self)
		local song = SongOrCourse()
		local diffColor = color("#FFFFFF")

		if song then
			local steps = StepsOrTrail(Player)
			if steps then
				local st = steps:GetStepsType()
				c.Panels:settext( THEME:GetString("Panel",ToEnumShortString(st)) )

				local diff = steps:GetDifficulty()
				local diffText = GetCustomDifficulty(st,diff,nil)
				c.Difficulty:diffuse(CustomDifficultyToColor(diffText))
				if diff == 'Difficulty_Edit' then
					local desc = steps:GetDescription()
					if desc ~= "" then
						c.Difficulty:settext(desc)
					else
						c.Difficulty:settext("(untitled)")
					end
				else
					c.Difficulty:settext( string.upper( THEME:GetString("CustomDifficulty",diffText) ) )
				end

				c.Meter:settext(steps:GetMeter())
				c.Meter:diffuse(CustomDifficultyToColor(diffText))
			else
				c.Meter:settext("?")
				c.Panels:settext("")
			end
		else
			c.Meter:settext("?")
			c.Panels:settext("")
		end
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentStepsP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
	CurrentTrailP1ChangedMessageCommand=function(self) if Player == PLAYER_1 then self:playcommand("Set") end end;
	CurrentStepsP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;
	CurrentTrailP2ChangedMessageCommand=function(self) if Player == PLAYER_2 then self:playcommand("Set") end end;

	LoadFont("_aero matics Bold 36px")..{
		Name="Meter";
		InitCommand=cmd(y,-16;shadowlength,2);
	};
	LoadFont("_eurostile bold 24px")..{
		Name="Difficulty";
		InitCommand=cmd(y,7;zoom,0.5;shadowlength,2;);
	};
	LoadFont("_eurostile bold 24px")..{
		Name="Panels";
		InitCommand=cmd(y,20;zoom,0.5;shadowlength,2;);
	};
};